// Helper to check non-empty values
#let has-content(value) = {
  value != none and value != "" and value != (:) and value != ()
}

// Badge colour lookup
#let get-badge-colour(colour-name, mode: "light") = {
  let is-dark = mode == "dark"
  if colour-name == "success" {
    if is-dark { rgb("#33cc88") } else { rgb("#009955") }
  } else if colour-name == "warning" {
    if is-dark { rgb("#ee9944") } else { rgb("#cc6600") }
  } else if colour-name == "danger" {
    if is-dark { rgb("#ff5555") } else { rgb("#cc0000") }
  } else if colour-name == "info" {
    if is-dark { rgb("#5599ee") } else { rgb("#0066cc") }
  } else {
    if is-dark { luma(170) } else { luma(128) }  // neutral default
  }
}

// Inline badge component
#let simple-badge(content, colour: "neutral", mode: "light") = {
  let base = get-badge-colour(colour, mode: mode)
  box(
    fill: base.lighten(80%),
    stroke: 0.5pt + base.lighten(40%),
    radius: 4pt,
    inset: 0.25em,
    text(size: 0.85em, fill: base, content)
  )
}

// Panel colour lookup by style
#let get-panel-colours(style) = {
  if style == "info" {
    (background: rgb("#0066cc").lighten(90%), border: rgb("#0066cc").lighten(50%), title: rgb("#0066cc"), content: luma(30))
  } else if style == "success" {
    (background: rgb("#009955").lighten(90%), border: rgb("#009955").lighten(50%), title: rgb("#009955"), content: luma(30))
  } else if style == "warning" {
    (background: rgb("#cc6600").lighten(90%), border: rgb("#cc6600").lighten(50%), title: rgb("#cc6600"), content: luma(30))
  } else if style == "danger" {
    (background: rgb("#cc0000").lighten(90%), border: rgb("#cc0000").lighten(50%), title: rgb("#cc0000"), content: luma(30))
  } else {
    // subtle / default
    (background: luma(245), border: luma(200), title: luma(60), content: luma(30))
  }
}

// Block panel component
#let render-panel(
  content,
  title: none,
  style: "subtle",
  icon: none,
  colours: (:),
  breakable: false,
) = {
  let panel-colours = get-panel-colours(style)

  // Build optional title display
  let title-display = if has-content(title) {
    block(
      below: 0.8em,
      text(
        size: 1.1em,
        weight: "semibold",
        fill: panel-colours.title,
        title
      )
    )
  }

  // Render the panel
  block(
    width: 100%,
    fill: panel-colours.background,
    stroke: 1pt + panel-colours.border,
    radius: 8pt,
    inset: 1.2em,
    breakable: breakable,
    {
      if title-display != none { title-display }
      text(fill: panel-colours.content, content)
    }
  )
}
