local function require_local(path)
  return require(quarto.utils.resolve_path(path):gsub('%.lua$', ''))
end

local wrapper = require_local("wrapper.lua")

--- Badge handler for inline .badge spans
function Span(span)
  if not quarto.doc.is_format('typst') then
    return span
  end

  if not span.classes:includes('badge') then
    return span
  end

  local content = pandoc.utils.stringify(span.content)
  local colour = span.attributes.colour or 'neutral'

  local typst_code = string.format(
    '#simple-badge(colour: "%s", mode: effective-brand-mode)[%s]',
    colour,
    content
  )

  return pandoc.RawInline('typst', typst_code)
end

--- Panel handler for block .panel divs
function Div(div)
  if not quarto.doc.is_format('typst') then
    return div
  end

  if not div.classes:includes('panel') then
    return div
  end

  local config = { wrapper = 'my-panel', arguments = true }
  return wrapper.build_wrapped_content(div, config, true)
end
